/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.hotspot.service.impl;

import com.tp_link.eap.domain.account.Role;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.hotspot.Operator;
import com.tp_link.eap.domain.site.Privilege;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.cloud.clouduser.repo.CloudUserRepository;
import com.tp_link.eap.monitor.hotspot.repo.OperatorRepository;
import com.tp_link.eap.monitor.hotspot.service.OperatorServiceI;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.user.service.PrivilegeServiceI;
import com.tp_link.eap.user.service.RoleService;
import com.tp_link.eap.user.service.UserService;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.p.a;
import com.tp_link.eap.util.p.b;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.validation.Validator;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="operatorService")
public class OperatorService
extends com.tp_link.eap.i.a.a<Operator>
implements OperatorServiceI {
    private static final Logger a = LoggerFactory.getLogger(OperatorService.class);
    @Autowired
    private OperatorRepository b;
    @Autowired
    private UserService c;
    @Autowired
    private PrivilegeServiceI d;
    @Autowired
    private RoleService e;
    @Autowired
    private Validator validator;
    @Autowired
    private CloudUserRepository f;

    @Override
    public boolean isNameExists(String name) {
        Operator operator = this.b.findByName(name);
        return operator != null;
    }

    @Override
    public OperationResponse checkOperatorOverLimit(ControlType controlType, JSONObject reqObj) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(1);
        hashMap.put("data", this.b.count() >= 50L);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse addOperator(Operator operator, List<String> sites) {
        Object object;
        OperationResult operationResult = this.a(operator);
        if (!operationResult.isSuccess()) {
            return new OperationResponse(ResErrorCode.d, operationResult.getMessage(), operationResult.getValue());
        }
        if (this.b.count() >= 50L) {
            a.debug("operator num {} has reached maximum", (Object)this.b.count());
            return new OperationResponse(ResErrorCode.bD);
        }
        Role role = this.e.getRoleByName("operator");
        if (operator.getId() != null) {
            object = (Operator)this.b.findOne((Serializable)((Object)operator.getId()));
            if (object == null) {
                return new OperationResponse(ResErrorCode.d);
            }
            object.setPassword(operator.getPassword());
            object.setNote(operator.getNote());
            this.b.save(object);
            operator = object;
        } else {
            if (this.isNameExists(operator.getName())) {
                return new OperationResponse(ResErrorCode.dV, String.format("Operator %s already existed.", operator.getName()), null);
            }
            if (this.c.isUserNameExists(operator.getName())) {
                return new OperationResponse(ResErrorCode.dW, String.format("name %s already existed.", operator.getName()), null);
            }
            operator.setCreatedTime(Long.valueOf(System.currentTimeMillis() / 1000L));
            operator.setRole(role);
            operator.setRoleName(role.getName());
            this.b.save(operator);
        }
        if (this.a(operator.getName(), sites)) {
            com.tp_link.eap.monitor.hotspot.security.a.b(operator.getName());
        }
        this.d.refreshUserPrivileges(operator.getName(), sites, role);
        object = this.d.getUserPrivileges(operator.getName());
        if (CollectionUtils.isEmpty((Collection)object)) {
            operator.setLastSite(null);
        } else {
            int n2;
            for (n2 = 0; n2 < object.size() && !((Privilege)object.get(n2)).getSiteName().equals(operator.getLastSite()); ++n2) {
            }
            if (n2 == object.size()) {
                operator.setLastSite(((Privilege)object.get(0)).getSiteName());
            }
        }
        this.b.save(operator);
        return new OperationResponse(ResErrorCode.a, String.format("Add Operator %s successfully.", operator.getName()), null);
    }

    private boolean a(String string, List<String> list) {
        List list2 = this.d.getUserPrivileges(string);
        if (CollectionUtils.isEmpty(list) && CollectionUtils.isEmpty((Collection)list2)) {
            return false;
        }
        if (CollectionUtils.isEmpty(list) != CollectionUtils.isEmpty((Collection)list2) || list.size() != list2.size()) {
            return true;
        }
        int n2 = 0;
        for (Privilege privilege : list2) {
            if (!list.contains(privilege.getSiteName())) continue;
            ++n2;
        }
        return n2 != list.size() || n2 != list2.size();
    }

    @Override
    public OperationResponse addOperator(Operator operator) {
        return this.addOperator(operator, null);
    }

    @Override
    public OperationResponse delOperByName(String name) {
        Operator operator = this.b.findByName(name);
        if (null == operator) {
            return new OperationResponse(ResErrorCode.dX, String.format("Observer %s not exists.", name), null);
        }
        this.b.delete(operator);
        com.tp_link.eap.monitor.hotspot.security.a.b(name);
        this.d.deleteUserPrivilege(name);
        return new OperationResponse(ResErrorCode.a, (Object)String.format("Observer %s was deleted.", name));
    }

    @Override
    public List<Operator> getAll() {
        List list = com.tp_link.eap.util.a.a.a((Iterable)this.b.findAll());
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    @Override
    public Operator getOperByName(String name) {
        if (null == name) {
            return null;
        }
        return this.b.findByName(name);
    }

    @Override
    public void deleteAll() {
        this.b.deleteAll();
    }

    public List<Operator> getList(QueryPage queryPage) {
        List<Operator> list = this.getList(queryPage, null, null, null);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Operator> getList(QueryPage queryPage, QuerySort querySort) {
        List<Operator> list = this.getList(queryPage, querySort, null, null);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Operator> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<Operator> list = this.getList(queryPage, null, filters, searchFilters);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Operator> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<Operator> list = this.b.getByFilters(queryPage, querySort, filters, searchFilters);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.b.getByFilters(null, null, filters, searchFilters).size();
    }

    private OperationResult a(Operator operator) {
        if (null == operator) {
            return new OperationResult(false, "Illegal parameter.");
        }
        if (!com.tp_link.eap.util.p.b.a((String)operator.getName(), (int)com.tp_link.eap.user.a.b.a, (int)com.tp_link.eap.user.a.b.b)) {
            return new OperationResult(false, "Invalid user name.");
        }
        if (!operator.getPassword().equals("") && !com.tp_link.eap.util.p.b.b((String)operator.getPassword(), (int)com.tp_link.eap.user.a.b.e, (int)com.tp_link.eap.user.a.b.f)) {
            return new OperationResult(false, "Invalid password.");
        }
        return new OperationResult(true, String.format("Operator %s is valid.", operator.getName()));
    }

    @Override
    public OperationResponse getGridOperators(ControlType controlType, JSONObject reqObj) {
        Object object;
        Object object2;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        String string = queryData.getSortName();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            queryData.setSortName("_id");
            queryData.setSortOrder("desc");
        } else {
            queryData.setSortName(string + ",_id");
        }
        Grid grid = new Grid(queryData);
        grid.initSearch(queryData.getSearchKey(), new String[]{"name", "password", "note"});
        long l2 = this.count(grid);
        grid.setTotalRows(l2);
        List list = this.getList(grid);
        if (null == list || list.isEmpty()) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        String string2 = null;
        Role role = null;
        if (controlType.equals((Object)ControlType.a) || controlType.equals((Object)ControlType.c)) {
            string2 = (String)SecurityUtils.getSubject().getPrincipal();
        } else if (controlType.equals((Object)ControlType.b) || controlType.equals((Object)ControlType.d)) {
            object2 = reqObj.optString("cloudUserSessionId");
            if (com.tp_link.eap.util.a.e.a((String)object2)) {
                a.warn("Failed to find sessionId in getCurrentCloudUserInfo");
                return com.tp_link.eap.util.e.aY;
            }
            String string3 = com.tp_link.eap.monitor.cloud.clouduser.a.a.a((String)object2);
            if (com.tp_link.eap.util.a.e.a((String)string3)) {
                a.warn("Failed to find accountId for session {}", object2);
                return com.tp_link.eap.util.e.aY;
            }
            object = this.f.findByAccountIdEncrypted(com.tp_link.eap.monitor.cloud.e.a.c(string3));
            if (object == null) {
                a.warn("Failed to find user for accountId {}", (Object)com.tp_link.eap.monitor.cloud.e.a.c(string3));
                return com.tp_link.eap.util.e.aY;
            }
            role = object.getRole();
            string2 = com.tp_link.eap.monitor.cloud.e.a.c(string3);
        } else {
            a.warn("Invalid controlType {}", (Object)controlType.a());
            return com.tp_link.eap.util.e.aY;
        }
        object2 = this.a(string2);
        if (null == object2 || object2.isEmpty()) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n2;
            object = this.a(((Operator)list.get(i2)).getName());
            if (null == object || object.isEmpty()) {
                if (controlType.equals((Object)ControlType.a) || controlType.equals((Object)ControlType.c)) {
                    if (SecurityUtils.getSubject().isPermitted("admin")) continue;
                    a.debug("this is the blank site operator: " + list.get(i2));
                    list.remove(i2--);
                    continue;
                }
                if (role != null && !role.getPermissions().contains("admin")) continue;
                a.debug("this is the blank site operator: " + list.get(i2));
                list.remove(i2--);
                continue;
            }
            for (n2 = 0; n2 < object.size() && !object2.contains(object.get(n2)); ++n2) {
            }
            if (n2 != object.size()) continue;
            list.remove(i2--);
        }
        queryData.setSortName(string);
        grid.setData(list);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse getOperator(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("operName", null);
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        return new OperationResponse(ResErrorCode.a, (Object)this.getOperByName(string));
    }

    @Override
    public OperationResponse saveOperator(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        JSONArray jSONArray = jSONObject.getJSONArray("selectedSites");
        jSONObject.remove("selectedSites");
        Operator operator = (Operator)JSONObject.toBean((JSONObject)jSONObject, Operator.class);
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)operator);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
            arrayList.add(jSONArray.optString(i2, null));
        }
        return this.addOperator(operator, arrayList);
    }

    @Override
    public OperationResponse deleteOperator(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        JSONArray jSONArray = jSONObject.getJSONArray("operNames");
        for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
            String string = jSONArray.getString(i2);
            OperationResponse operationResponse = this.delOperByName(string);
            if (operationResponse.success()) continue;
            return operationResponse;
        }
        return new OperationResponse(ResErrorCode.a, "Operator was deleted.", null);
    }

    @Override
    public OperationResponse getHotspotLoginState(ControlType controlType, JSONObject reqObj) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        switch (controlType) {
            case a: 
            case c: {
                Subject subject = SecurityUtils.getSubject();
                String string = (String)subject.getPrincipal();
                if (string == null) {
                    hashMap.put("login", false);
                    break;
                }
                String string2 = (String)((Object)subject.getSession().getId());
                boolean bl = !com.tp_link.eap.monitor.hotspot.security.a.d(string, string2) || !com.tp_link.eap.user.b.a.d((String)string, (String)string2);
                hashMap.put("login", bl);
                break;
            }
            case b: 
            case d: {
                hashMap.put("login", true);
                break;
            }
            default: {
                a.warn("Invalid controlType {}", (Object)controlType.a());
                hashMap.put("login", false);
            }
        }
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse hotspotLogin(ControlType controlType, JSONObject reqObj) {
        Object object;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            a.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        Operator operator = (Operator)JSONObject.toBean((JSONObject)jSONObject, Operator.class);
        if (operator == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        a.debug("User name: {}", (Object)operator.getName());
        if (!com.tp_link.eap.util.p.b.a((String)operator.getName(), (int)1, (int)com.tp_link.eap.user.a.b.b)) {
            return new OperationResponse(ResErrorCode.dY);
        }
        Subject subject = SecurityUtils.getSubject();
        String string = (String)((Object)subject.getSession().getId());
        a.debug(" hotspot sessionid: {}", (Object)string);
        if (subject.getPrincipal() != null && subject.isAuthenticated()) {
            a.debug("current subject is authenticated.");
            return new OperationResponse(ResErrorCode.a, "Login with existed Operator successfully.", null);
        }
        if (CollectionUtils.isEmpty((Collection)this.d.getUserPrivileges(operator.getName()))) {
            return new OperationResponse(ResErrorCode.dZ);
        }
        com.tp_link.eap.monitor.hotspot.security.b b2 = new com.tp_link.eap.monitor.hotspot.security.b(operator.getName(), operator.getPassword());
        try {
            subject.login((AuthenticationToken)b2);
            com.tp_link.eap.monitor.hotspot.security.a.a(operator.getName(), string);
            object = this.getOperByName(operator.getName());
            com.tp_link.eap.monitor.hotspot.security.a.a(object.getName(), object.getRole().getPermissions());
        }
        catch (Exception exception) {
            return new OperationResponse(ResErrorCode.ea);
        }
        object = this.getOperByName(operator.getName()).getLastSite();
        com.tp_link.eap.d.b.a((String)string, (String)object);
        return new OperationResponse(ResErrorCode.a, "Operator Login successfully.", null);
    }

    private List<String> a(String string) {
        if (null == string) {
            return null;
        }
        List list = this.d.getUserPrivileges(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Privilege privilege : list) {
            arrayList.add(privilege.getSiteName());
        }
        return arrayList;
    }
}

